function index=MitchellRank(MFs,H)

%
% index=MitchellRank(MFs)
%
% To rank IT2 FSs using Mitchell's method
%
% H.B. Mitechell, Ranking type-2 fuzzy numbers, IEEE Trans. on Fuzzy Systems, vol. 14, no. 2, 
% pp. 287294, 2006.
%
% Dongrui WU (dongruiw@usc.edu), 4/19/2009
%
% MFs: an N*9 matrix containing the parameters of the N IT2 FSs, each represented by 9
% parameters (see Fig. 1 in Readme.doc)
% H: number of embedded T1 FSs used; default to be 5.
%
% index: Rank of the IT2 FSs

if nargin==1
    H=5;
end

M=size(MFs,1);
minX=min(MFs(:,1));
maxX=max(MFs(:,4));
N=200;
X=linspace(minX,maxX,N);
centroids=zeros(H,M);
for m=1:M
    for h=1:H
        upperA=mg(X,MFs(m,1:4));
        lowerA=mg(X,MFs(m,5:8),[0 MFs([9 9]) 0]);
        A=lowerA+rand(1,N).*(upperA-lowerA);
        centroids(h,m)=A*X'/sum(X);
    end
end

ranks=zeros(H^M,M);
centroid=zeros(1,M);
for i=1:H^M
    index=ones(1,M);
    temp=dec2base(i-1,H);
    for j=1:length(temp)
        index(M-j+1)=index(M-j+1)+str2num(temp(end-j+1));
    end
    for j=1:M
        centroid(j)=centroids(index(j),j);
    end
    [temp,ranks(i,:)]=sort(centroid);
end

[temp,index]=sort(mean(ranks,1));


